from django.utils.translation import ugettext_lazy as _


class FIELD_TYPE(object):
    CHARFIELD = 'charfield'
    PASSPORT_LOGIN = 'passportlogin'
    UNDO = 'undo'
    INTEGER = 'integerfield'
    BOOLEAN = 'booleanfield'
    CHOICE = 'choicefield'
    SUGGEST = 'suggestfield'

    TYPE_CHOICES = (
        (CHARFIELD, _('Текстовое поле')),
        (PASSPORT_LOGIN, _('Паспортный логин')),
        (UNDO, _('Отменить вышестоящее поле')),
        (INTEGER, _('Целое поле')),
        (BOOLEAN, _('Булево поле. По умолчанию - checkbox')),
        (CHOICE, _('Выбор одного варианта из нескольких. По умолчанию – select')),
        (SUGGEST, _('Выбор одного из предлагаемых саджестом')),
    )


class FIELD_STATE(object):
    CREATED = 'created'
    ACTIVE = 'active'
    DEPRIVING = 'depriving'
    DEPRIVED = 'deprived'

    STATE_CHOICES = (
        (CREATED, _('созданo')),
        (ACTIVE, _('активно')),
        (DEPRIVING, _('отзывается')),
        (DEPRIVED, _('отозвано')),
    )
