# coding: utf-8


from django.utils.translation import ugettext_lazy as _


class SYSTEM_PASSPORT_POLICY(object):
    UNCONSTRAINED = 'unconstrained'
    UNIQUE_FOR_USER = 'unique_for_user'

    CHOICES = (
        (UNCONSTRAINED, _('Нет ограничений на количество логинов у пользователя или количества ролей, '
                          'связанных с логином')),
        (UNIQUE_FOR_USER, _('Один логин для всех ролей каждого пользователя системы'))
    )


class SYSTEM_GROUP_POLICY(object):
    UNAVAILABLE = 'unavailable'
    UNAWARE = 'unaware'
    AWARE = 'aware'
    AWARE_OF_MEMBERSHIPS_WITHOUT_LOGINS = 'aware_of_memberships_without_logins'
    AWARE_OF_MEMBERSHIPS_WITH_LOGINS = 'aware_of_memberships_with_logins'

    CHOICES = (
        (UNAVAILABLE, _('Система не поддерживает групповые роли')),
        (UNAWARE, _('Система поддерживает групповые роли, но сама про группы ничего не знает')),
        (AWARE, _('Система поддерживает групповые роли и сама следит за составом групп')),
        (AWARE_OF_MEMBERSHIPS_WITHOUT_LOGINS, _('Система поддерживает групповые роли и получает информацию '
                                 'об изменении состава групп от IDM')),
        (AWARE_OF_MEMBERSHIPS_WITH_LOGINS, _('Система поддерживает групповые роли, получает информацию '
                                             'об изменении состава групп и привязанных логинах от IDM')),
    )
    AVAILABLE = {UNAWARE, AWARE, AWARE_OF_MEMBERSHIPS_WITHOUT_LOGINS, AWARE_OF_MEMBERSHIPS_WITH_LOGINS}
    AWARE_OF_GROUPS = {AWARE, AWARE_OF_MEMBERSHIPS_WITHOUT_LOGINS, AWARE_OF_MEMBERSHIPS_WITH_LOGINS}
    SUPPORT_GROUP_ROLES = {AWARE, AWARE_OF_MEMBERSHIPS_WITHOUT_LOGINS, AWARE_OF_MEMBERSHIPS_WITH_LOGINS, UNAWARE}
    AWARE_OF_MEMBERSHIPS = {AWARE_OF_MEMBERSHIPS_WITHOUT_LOGINS, AWARE_OF_MEMBERSHIPS_WITH_LOGINS}
    ALL_POLICIES = AVAILABLE | {UNAVAILABLE}


class SYSTEM_REQUEST_POLICY(object):
    SUBORDINATES = 'subordinates'
    ANYONE = 'anyone'

    CHOICES = (
        (SUBORDINATES, _('Только для себя и своих подчиненных можно запрашивать роли')),
        (ANYONE, _('Все могут запрашивать роли для всех')),
    )


class SYSTEM_ROLE_GRANT_POLICY(object):
    IDM = 'idm'
    SYSTEM = 'system'

    CHOICES = (
        (IDM, _('Подтвержденная роль становится активной')),
        (SYSTEM, _('Требуется подтверждение системы')),
    )


class SYSTEM_ROLETREE_POLICY(object):
    EDITABLE = 'editable'
    NONEDITABLE = 'noneditable'

    CHOICES = (
        (EDITABLE, _('Можно редактировать')),
        (NONEDITABLE, _('Нельзя редактировать')),
    )


class SYSTEM_REVIEW_ON_RELOCATE_POLICY(object):
    REVIEW = 'review'
    IGNORE = 'ignore'

    CHOICES = (
        (REVIEW, _('Перезапрашивать роли при смене подразделения')),
        (IGNORE, _('Не перезапрашивать роли при смене подразделения'))
    )


class SYSTEM_INCONSISTENCY_POLICY(object):
    STRICT_SOX = 'donottrust_strict'
    STRICT = 'donottrust'
    TRUST = 'trust'
    TRUST_IDM = 'trust_idm'

    CHOICES = (
        (STRICT_SOX, _('Не доверяем системе, отзываем роль и запрашиваем заново')),
        (STRICT, _('Не доверяем системе, импортируем роль и требуем повторного подтверждения согласно workflow')),
        (TRUST, _('Доверяем системе, не требуем повторного подтверждения')),
        (TRUST_IDM, _('Доверяем IDM, разрешаем расхождения в пользу IDM'))
    )


class SYSTEM_WORKFLOW_APPROVE_POLICY(object):
    ANY = 'any'
    ANOTHER = 'another'

    CHOICES = (
        (ANY, _('Изменяющий воркфлоу может его подтверждать')),
        (ANOTHER, _('Изменяющий воркфлоу не может его подтверждать'))
    )


class SYSTEM_AUTH_FACTOR(object):
    # AUTH_FACTORS
    NO = 'no'
    CERT = 'cert'
    TVM = 'tvm'

    CHOICES = (
        (NO, _('Без авторизации')),
        (CERT, _('Сертификат')),
        (TVM, 'TVM')
    )


class SYSTEM_AUDIT_METHOD(object):
    GET_ROLES = 'get_roles'
    GET_ALL_ROLES = 'get_all_roles'

    CHOICES = (
        (GET_ROLES, _('Ручка get-roles (новая, постраничная)')),
        (GET_ALL_ROLES, _('Ручка get-all-roles (старая)')),
    )


class SYSTEM_AUDIT_BACKEND(object):
    DATABASE = 'database'
    MEMORY = 'memory'

    CHOICES = (
        (DATABASE, _('В БД (старый)')),
        (MEMORY, _('В памяти (новый)')),
    )


class SYSTEM_PLUGIN_TYPE(object):
    GENERIC = 'generic'
    DUMB = 'dumb'
    GENERIC_LEGACY = 'generic_legacy'
    GENERIC_SELF = 'generic_self'
    GENERIC_CONNECT = 'generic_connect'

    UNPRIVILEGED_CHOICES = (
        (GENERIC, 'generic'),
        (DUMB, 'dumb'),
    )
    CHOICES = UNPRIVILEGED_CHOICES + (
        (GENERIC_LEGACY, 'generic (legacy)'),
        (GENERIC_SELF, 'generic (only for IDM)'),
        (GENERIC_CONNECT, 'generic (connect only)'),
    )

    GENERICS = {GENERIC, GENERIC_LEGACY, GENERIC_SELF, GENERIC_CONNECT}


class SYSTEM_NODE_PLUGIN_TYPE(object):
    YAML = 'yaml'
    INFO = 'info'
    DUMB = 'dumb'

    CHOICES = (
        (YAML, _('yaml')),
        (INFO, _('info')),
        (DUMB, _('dumb'))
    )


class SYSTEM_STATE(object):
    ACTIVE = 'active'
    INACTIVE = 'inactive'
    BROKEN = 'broken'

    CHOICES = (
        (ACTIVE, _('Активна')),
        (INACTIVE, _('Выключена')),
        (BROKEN, _('Сломана')),
    )


class SYSTEM_CONSTANTS(object):
    SMALL_NODES_THRESHOLD = 25000
    SMALL_ROLES_THRESHOLD = 8000
    SIZE_BIG = 'big'
    SIZE_SMALL = 'small'


class SYSTEM_WORKFLOW_EXECUTION_METHOD(object):
    PLAIN = 'plain'
    SANDBOXED = 'sandboxed'

    CHOICES = (
        (PLAIN, _('Простой')),
        (SANDBOXED, _('В песочнице')),
    )


class SYSTEM_WORKFLOW_INTERPRETER(object):
    PYTHON_2_7 = 'python_2_7'
    PYTHON_3_6 = 'python_3_6'

    CHOICES = (
        (PYTHON_2_7, _('Python 2.7')),
        (PYTHON_3_6, _('Python 3.6')),
    )


class IDM_SYSTEM_TREE:
    SYSTEM_ON_PATH = '/group/system/system_on/'
    RESPONSIBLES_ROLE_SLUG = 'responsible'
    TEAM_MEMBERS_ROLE_SLUG = 'users_view'

    CHOICES = (
        (RESPONSIBLES_ROLE_SLUG, _('слаг роли ответственных')),
        (TEAM_MEMBERS_ROLE_SLUG, _('слаг роли команды')),
    )


class SYSTEM_CHECKS:
    WITH_INHERITANCE = 'with_inheritance'
    WITH_EXTERNAL = 'with_external'
    WITH_ROBOTS = 'with_robots'
    WITHOUT_HOLD = 'without_hold'

    SLUGS = [WITH_ROBOTS, WITH_EXTERNAL, WITH_INHERITANCE, WITHOUT_HOLD]

    NAMES = {
        WITH_INHERITANCE: _('Выдавать вложенным департаментам'),
        WITH_EXTERNAL: _('Выдавать внешним'),
        WITH_ROBOTS: _('Выдавать роботам'),
        WITHOUT_HOLD: _('Отзывать сразу при выходе из группы'),
    }
