# coding: utf-8

from __future__ import unicode_literals

# maximal integer supported by PositiveSmallIntegerField
from django.utils.translation import ugettext_lazy as _

DEFAULT_PRIORITY = 32767


class PRIORITY_POLICIES(object):
    DEPUTY_LESS = 'deputy_less'  # у руководителей приоритет меньше чем у заместителей на одном уровне
    HEAD_LESS = 'head_less'  # у заместителей меньше чем у руководителей на одном уровне
    EQUAL = 'equal'  # одинаковый приоритет у тех и у других на одном уровне
    NO_DEPUTIES = 'no_deputies'  # вернуть только руководителей


class RUN_REASON(object):
    CHECK_TTL = 'check_ttl'
    CREATE_APPROVE_REQUEST = 'create_approve_request'
    DOCTEST = 'doctest'
    IMPORT = 'import'
    ONLINE_TEST = 'online_test'
    RERUN = 'rerun'
    REQUEST = 'request'
    SIMULATE = 'simulate'
    DEPRIVE = 'deprive'
    REREQUEST = 'rerequest'


class WORKFLOW_CONTAINER_START_STATUS:
    CONTAINER_START_SUCCESS = 'container_start'


class WORKFLOW_CONTAINER_RESPONSE(object):
    FINISH = 0
    REQUEST = 1
    ERROR = 2
    POSTPROCESS_REQUEST = 3


class WORKFLOW_IDM_RESPONSE(object):
    RUN_WORKFLOW = 0
    RUN_DOCTESTS = 1

    RESPONSE_OK = 10
    RESPONSE_EXCEPTION = 11


class REQUEST_TYPE:
    REQUEST = 'request'
    DEPRIVE = 'deprive'

    CHOICES = (
        (REQUEST, _('Запросить')),
        (DEPRIVE, _('Отозвать')),
    )
