from django.utils.translation import ugettext_lazy as _


class IDMError(Exception):
    message: str = _('Неизвестная ошибка IDM')

    def __init__(self, message=None, **data):
        self.message = message or _(self.message)
        self.data = data
        super().__init__(message)


class RoleStateSwitchError(IDMError):
    message = _('Статус роли не может быть изменён')


class UnresolvableInconsistencyError(IDMError):
    message = _('Расхождение не может быть разрешено')


class SynchronizationError(IDMError):
    message = _('Ошибка получения списка ролей из системы')


class TransferStateSwitchError(IDMError):
    message = _('Статус перемещения не может быть изменён')


class DismissedThresholdViolation(IDMError):
    message = _('Блокировка пользователей невозможна: слишком большое число пользователей необходимо заблокировать')


class MembershipPassportLoginError(IDMError):
    message = _('Ошибка при работе с паспортным логином и членством')


class PassportLoginGenerationError(IDMError):
    message = _('Все сгенерированные нами логины заняты в паспорте')


class MultiplePassportLoginsError(IDMError):
    message = _('Пользователь имеет больше одного паспортного логина')


class MultiplePassportLoginUsersError(IDMError):
    message = _('Попытка привязать пользователя к чужому паспортному логину')


class PushDisabled(IDMError):
    message = _('Пуш в систему отключен')


class URLNotDefined(IDMError):
    message = _('У системы не установлен URL')
