# coding: utf-8

import logging

from django.core.management.base import CommandError

from idm.core.exceptions import DismissedThresholdViolation
from idm.core.management.base import IdmBaseCommand
from idm.users.models import User

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Проверить и заблокировать в AD пользователей, которых уже блокировали'
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--mode', action='store', dest='mode', required=False, choices=('full', 'fast'),
        )
        parser.add_argument(
            '--threshold', action='store', dest='threshold', type='int', required=False,
        )
        parser.add_argument(
            '--block',
            action='store_true',
            dest='block',
            default=False,
        )

    def idm_handle(self, *args, **options):
        if not options['mode']:
            raise CommandError('mode is required')
        block = options.get('block', False)
        try:
            User.objects.block_dismissed_in_ldap(options['mode'], options.get('threshold'), block=block)
        except DismissedThresholdViolation:
            raise CommandError('Dismissed users threshold violation')
