
# -*- coding: utf-8 -*-


import logging

from idm.core.management.base import IdmBaseCommand
from idm.core.models import UserPassportLogin
from idm.sync import passport

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Проверяет все актуальные логины, не дореганы ли они, для дореганных подпинывает ожидающие их роли'
    USE_LOCK = True
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)

        parser.add_argument(
            '--force',
            dest='force',
            action='store_true',
            default=None,
            help='Смотреть на логины во всех статусах',
        )
        parser.add_argument(
            '--login', action='store', dest='login', required=False,
        )

    def check_login(self, login, force):
        if passport.check_if_fully_registered(login.login):
            login.is_fully_registered = True
            login.save(update_fields=['is_fully_registered'])
            log.info('Login %s is now considered to be fully registered', login.login)
        elif force and login.is_fully_registered:
            login.is_fully_registered = False
            login.save(update_fields=['is_fully_registered'])
            log.info('Login %s is now forcefully considered to be not fully registered', login.login)

    def idm_handle(self, *args, **options):
        login = options.get('login')
        force = options.get('force', False)

        logins = UserPassportLogin.objects.all()
        if not force:
            logins = logins.filter(is_fully_registered=False)
        if login:
            logins = UserPassportLogin.objects.filter(login=login)
            if not logins.exists():
                print('WARNING: login "{}" with given filters not found. The command will have no effect'.format(login))

        for login in logins.iterator():
            self.check_login(login, force=force)
