# -*- coding: utf-8 -*-


import logging

from idm.core.management.base import IdmBaseCommand
from idm.core.models import Role

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """Проверяем awaiting роли"""

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', action='store', dest='system', type='system', required=False
        )

    def idm_handle(self, *args, **options):
        system = options.get('system')
        Role.objects.poke_awaiting_roles(system=system)
