# coding: utf-8


import logging

from idm.core.management.base import IdmBaseCommand
from idm.core.models import Transfer
from idm.utils.log import log_duration

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
    Сверяемся с данными Стаффа и пересматриваем роли только у тех подразделений, где это необходимо сделать.
    """
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--from-date',
            action='store',
            dest='from_date',
            default=None,
            type='datetime'
        )
        parser.add_argument(
            '--to_date',
            action='store',
            dest='to_date',
            default=None,
            type='datetime'
        )

    def idm_handle(self, *args, **options):
        with log_duration(log, 'Autoresolving transfers'):
            Transfer.objects.autoresolve(from_date=options.get('from_date'), to_date=options.get('to_date'))
