# -*- coding: utf-8 -*-


import logging

from django.db.models import Q
from django.utils import timezone

from idm.core.management.base import IdmBaseCommand
from idm.inconsistencies.models import MatchingRole

log = logging.getLogger(__name__)

DAYS_TO_DELETE_MATCHING_ROLES = 7


class Command(IdmBaseCommand):
    help = 'Удаляем из таблицы upravlyator_matching_roles записи, привязанные к старым actions'
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', action='store', dest='system', type='system', required=False
        )
        parser.add_argument(
            '--dry-run', action='store_true', dest='dry_run', default=False,
            help='Написать, сколько matching roles будет удалено'
        )

    def idm_handle(self, *args, **options):
        dry_run = options.get('dry_run', False)

        filtres = Q(inconsistency__sync_key__added__lt=timezone.now() - timezone.timedelta(days=DAYS_TO_DELETE_MATCHING_ROLES))
        system = options.get('system', None)
        if system:
            filtres &= Q(inconsistency__system=system)

        matching_roles = MatchingRole.objects.filter(filtres)
        log.info('Matching roles to delete: {}'.format(matching_roles.count()))
        if not dry_run:
            log.info('Start deleting matching roles')
            matching_roles.delete()
