# coding: utf-8


import logging

import constance
from django.utils import timezone

from idm.core.management.base import IdmBaseCommand
from idm.core.models import ActionTiny

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """ Удаляет старые простые действия"""

    def idm_handle(self, *args, **options):
        ActionTiny.objects.filter(
            finish__lte=timezone.now() - timezone.timedelta(days=constance.config.ACTION_TINY_EXPIRE_TIME_DAYS)
        ).delete()
