# -*- coding: utf-8 -*-


import logging

from idm.core.management.base import IdmBaseCommand
from idm.core.models import System

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """Отзываем просроченные роли."""
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', action='store', dest='system', type='system', required=False
        )
        parser.add_argument(
            '--now-is',
            action='store',
            dest='now_is',
            default=None,
            type='datetime'
        )

    def idm_handle(self, *args, **options):
        system = options.get('system')
        systems = System.objects.get_operational()
        if system:
            systems = [system]
        for system in systems:
            try:
                system.deprive_expired_roles(deadline=options.get('now_is'))
            except Exception:
                log.exception('Error during depriving expired roles for system %s', system.slug)
