# -*- coding: utf-8 -*-


import logging

from django.core.management import CommandError

from idm.core.exceptions import DismissedThresholdViolation
from idm.core.management.base import IdmBaseCommand
from idm.core.tasks import DismissUser
from idm.users.models import User

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Отзываем роли у уволенных сотрудников.'
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--threshold', action='store', dest='threshold', type='int', required=False,
        )
        parser.add_argument(
            '--block',
            action='store_true',
            dest='block',
            default=False,
        )

    def idm_handle(self, *args, **options):
        block = options.get('block', False)
        try:
            if block:
                method_name = 'apply'
            else:
                method_name = 'apply_async'

            with_active_roles = User.objects.dismissed().with_deprivable_roles()
            dismissed_count = with_active_roles.count()
            # TODO: Добавить в check_dismissed_count возможность выбора шаблона,
            # сейчас она пишет тем же текстом, что и про незаблокированнных в AD
            User.objects.check_dismissed_count(dismissed_count, options.get('threshold'))

            with_active_roles = with_active_roles.values_list('username', flat=True)

            for username in with_active_roles:
                log.info('Scheduling a task to dismiss user %s', username)
                method = getattr(DismissUser, method_name)
                method(kwargs={
                    'username': username,
                })

        except DismissedThresholdViolation:
            raise CommandError('Dismissed users threshold violation')
        except Exception:
            log.exception('error during command execution')
            raise
