# -*- coding: utf-8 -*-


import logging

from idm.core.models import RoleNode
from idm.core.management.base import IdmBaseCommand

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """Одноразовая команда, отзывает задублированные роли. Пуша в систему при этом не должно происходить."""

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', action='store', dest='system', type='system', required=True
        )

    def idm_handle(self, *args, **options):
        system = options.get('system')
        print('Deleting system %s' % system)
        qs = RoleNode.objects.filter(system=system, level__gt=0).order_by('-level').iterator()
        for rolenode in qs:
            rolenode.delete()
        system.delete()
        print('System %s deleted' % system)
