# coding: utf-8

import logging

from django.db import connection

from idm.core.management.base import IdmBaseCommand
from idm.core.models import Action
from idm.core.models import RoleAlias

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
        Этот скрипт убирает дубликаты в RoleAlias
    """
    intranet_only = True

    def idm_handle(self, *args, **options):
        cursor = connection.cursor()
        log.info('getting all dubs')

        cursor.execute('''select node_id, type, name, name_en, count(*) 
                          from upravlyator_rolealias 
                          where is_active=True 
                          group by node_id, type, name, name_en 
                          having count(*) > 1;''')
        all_duplicates = cursor.fetchall()
        cursor.close()
        for node_id, type, name, name_en, count in all_duplicates:
            duplicates = list(
                RoleAlias.objects.filter(
                    node_id=node_id,
                    type=type,
                    name=name,
                    name_en=name_en,
                    is_active=True
                ).
                values_list('pk', flat=True)
            )
            to_save = duplicates[0]
            to_remove = duplicates[1:]
            log.info('dublicates on %s,%s,%s,%s', node_id, type, name, name_en)
            log.info('saving %s', to_save)
            log.info('removing %s', to_remove)
            actions = Action.objects.filter(role_alias__pk__in=to_remove)
            actions.update(role_alias=to_save)
            RoleAlias.objects.filter(pk__in=to_remove).update(is_active=False)
