# coding: utf-8

import logging

from django.db import connection
from django.utils import timezone

from idm.core.management.base import IdmBaseCommand
from idm.core.models import NodeResponsibility
from idm.core.models import Action

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
        Этот скрипт убирает дубликаты в NodeResponsibility
    """
    intranet_only = True

    def idm_handle(self, *args, **options):
        cursor = connection.cursor()
        log.info('getting all dubs')
        cursor.execute('''select node_id, user_id, is_active, count(*) from
                          upravlyator_noderesponsibility
                          where is_active
                          group by node_id, user_id, is_active having count(*) > 1''')
        all_duplicates = cursor.fetchall()
        cursor.close()
        for node_id, user_id, is_active, count in all_duplicates:
            duplicates = list(
                NodeResponsibility.objects.filter(node_id=node_id, user_id=user_id, is_active=True).
                values_list('pk', flat=True)
            )
            to_save = duplicates[0]
            to_remove = duplicates[1:]
            log.info('dublicates on %s,%s', node_id, user_id)
            log.info('saving %s', to_save)
            log.info('removing %s', to_remove)
            actions = Action.objects.filter(node_responsibility__pk__in=to_remove)
            actions.update(node_responsibility=to_save)
            NodeResponsibility.objects.filter(pk__in=to_remove).update(is_active=False)
