import logging

from django.db import transaction, connection

from idm.core.management.base import IdmBaseCommand
from idm.core.models import Action
from idm.core.constants.action import ACTION

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    intranet_only = True

    def idm_handle(self, *args, **options):
        batch_size = 1000
        actions_to_migrate = (
            ACTION.ROLE_NODE_RESPONSIBILITY_CREATED,
            ACTION.ROLE_NODE_RESPONSIBILITY_REMOVED,
            ACTION.ROLE_NODE_RESPONSIBILITY_CHANGED
        )
        SQL_MIGRATE_ACTIONS = '''
        INSERT INTO core_rolenoderesponsibilityaction (id, action, added, data, node_responsibility_id,
        parent_id, requester_id, role_node_id, system_id)
        SELECT id, action, added, data, node_responsibility_id, parent_id, requester_id, role_node_id, system_id
        FROM upravlyator_action 
        WHERE id IN %s;
        
        DELETE FROM upravlyator_action WHERE id in %s;
        '''

        while True:
            old_model_actions_ids = tuple(
                Action.objects
                .filter(action__in=actions_to_migrate)
                .order_by()
                .values_list('id', flat=True)[:batch_size]
            )
            if not old_model_actions_ids:
                log.info('All actions are migrated')
                break

            with transaction.atomic():
                with connection.cursor() as cursor:
                    cursor.execute(SQL_MIGRATE_ACTIONS, [old_model_actions_ids, old_model_actions_ids])
