# -*- coding: utf-8 -*-


import logging

from django.core.management.base import BaseCommand

from idm.core.models import Role
from idm.utils.lock import lock

log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = """Одноразовая команда, удаляющая персональные роли, выданные по групповым в group-aware системах"""

    @lock
    def handle(self, *args, **options):
        qs = Role.objects.filter(system__group_policy='aware', parent__isnull=False, group=None)
        log.info('Deleting %d personal roles in group-aware systems', qs.count())
        for role in qs.iterator():
            role.delete()
        log.info('Deleted personal roles in group-aware systems')
