# -*- coding: utf-8 -*-


import logging

from django.db import connection, transaction

from idm.core.management.base import IdmBaseCommand

log = logging.getLogger(__name__)

COUNT_CLOSURES_SQL = """
SELECT COUNT(*)
FROM users_groupclosure closure
JOIN users_groupclosure g ON closure.child_id = g.id;
"""

FIX_CLOSURE_TREE_SQL = """
WITH RECURSIVE rec AS (
  SELECT
    parent_id AS ancestor,
    id AS descendant,
    ARRAY[id] AS descendants
  FROM users_group WHERE parent_id IS NOT NULL

  UNION ALL

  SELECT
    parent_id AS ancestor,
    descendant,
    descendants || ancestor AS descendants
  FROM users_group
  JOIN rec ON id = ancestor
  WHERE not (ancestor = any(descendants)) AND parent_id IS NOT NULL
),
self_rec AS (
  SELECT id AS ancestor, id AS descendant, ARRAY[]::integer[] AS descendants
  FROM users_group
),
all_rec AS (
    SELECT * FROM rec
    UNION ALL
    SELECT * FROM self_rec
)
INSERT INTO users_groupclosure (depth, child_id, parent_id)
SELECT
  COALESCE(array_length(descendants, 1), 0), -- длина пустого массива - NULL
  descendant,
  ancestor
FROM all_rec
LEFT JOIN users_groupclosure closure
    ON ancestor=closure.parent_id AND descendant=closure.child_id
WHERE closure.id IS NULL;
"""


class Command(IdmBaseCommand):
    help = """Одноразовая команда, создаёт отсутствующие записи в таблице users_groupclosure"""

    @transaction.atomic
    def idm_handle(self, *args, **options):
        # Находим недостающие записи и создаём их
        with connection.cursor() as cursor:
            cursor.execute(COUNT_CLOSURES_SQL)
            before = cursor.fetchone()[0]
            cursor.execute(FIX_CLOSURE_TREE_SQL)
            cursor.execute(COUNT_CLOSURES_SQL)
            after = cursor.fetchone()[0]
            log.info('%s groups closure records were created', after-before)
