# coding: utf-8

import logging

import waffle
from django.db import connection

from idm.core.management.base import IdmBaseCommand
from idm.utils.lock import lock

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = '''Проставляем время увольнения и время блокировки в AD всем пользователям'''

    SQL = '''
    UPDATE upravlyator_user
       SET idm_found_out_dismissal = (
       CASE
           WHEN fired_at IS NULL THEN now()
           ELSE fired_at::timestamp
       END)
     WHERE is_active=FALSE AND type='user';
    
    UPDATE upravlyator_user
       SET ldap_blocked_timestamp = idm_found_out_dismissal
     WHERE ldap_active=FALSE AND is_active=FALSE AND type='user';
    '''

    @lock
    def idm_handle(self, *args, **options):
        if not waffle.switch_is_active('update_dissmised_and_ad_blocked_dates'):
            return

        with connection.cursor() as cursor:
            cursor.execute(self.SQL)
