# -*- coding: utf-8 -*-


import logging

from idm.core.models import GroupMembershipSystemRelation, System
from idm.core.management.base import IdmBaseCommand

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Отправляет информацию о членствах пользователей в системы'
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', type='system', required=False
        )
        parser.add_argument(
            '--force',
            action='store_true',
            dest='force',
            default=False,
        )

    def process_system(self, system, force=False):
        log.info('Start groupmembership_system_relations push for %s', system.slug)
        system.push_activating_group_memberships_async()
        system.push_depriving_group_memberships_async(force=force)
        system.push_need_update_group_memberships_async()
        log.info('Groupmembership_system_relations for %s have been pushed to system', system.slug)

    def idm_handle(self, *args, **options):
        system = options.get('system')
        force = options.get('force', False)

        if system:
            self.process_system(system, force)
        else:
            log.info('Start groupmembership_system_relations push')
            systems = System.objects.get_systems_with_group_sync_policy()
            for system in systems:
                self.process_system(system, force)
            log.info('All groupmembership_system_relations have been pushed')
