from idm.core.models import System
from idm.core.management.base import IdmBaseCommand
from idm.core.node_pipeline import NodePipeline
from idm.core.tasks.nodes import RecalcNodePipelineTask


class Command(IdmBaseCommand):
    help = """Команда находит в системе узлы в статусе отличном от Good и приводит их в актуальное состояние"""

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', action='store', dest='system', type='system', required=False
        )
        parser.add_argument(
            '--sync', action='store_true', required=False
        )

    def idm_handle(self, *args, **options):
        block = options.get('sync', False)

        system = options.get('system')
        systems = System.objects.select_related('metainfo').operational()
        if system:
            systems = [system]

        for system in systems:
            if block:
                NodePipeline(system).locked_run(block=True)
            else:
                RecalcNodePipelineTask.apply_async(kwargs={
                    'system_id': system.pk,
                })
