# -*- coding: utf-8 -*-


import logging

from django.conf import settings
from django.core.cache import cache

from idm.api.v1 import firewall
from idm.core.management.base import IdmBaseCommand
from idm.users.models import User

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """Обновление кеша правил фаервола"""

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--user',
            action='store',
            required=False,
            default=firewall.FIREWALL_ROBOT_USERNAME,
        )
        parser.add_argument('--system', action='store', required=False)
        parser.add_argument(
            '--expand-groups',
            action='store_true',
            dest='expand_groups',
            required=False,
        )

    def idm_handle(self, *args, **options):
        system = options.get('system')
        user = User.objects.get(username=options.get('user'))
        logging.getLogger()
        expand_groups = options.get('expand_groups')
        self.logger.info(f'System: {system}, user: {user}, expand_groups: {expand_groups}')
        cache_key = firewall.get_cache_key(user, system, expand_groups=expand_groups)
        rules = firewall.get_firewall_rules(user, system, expand_groups=expand_groups)
        cache.set(cache_key, rules, timeout=settings.FIREWALL_RULES_CACHE_TIMEOUT)
