# -*- coding: utf-8 -*-

import logging

from idm.core.management.base import IdmBaseCommand
from idm.core.models import System

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
        Этот скрипт обнуляет создателя у новосозданных системы, чтобы разрешения получались только через внутренние роли
    """
    intranet_only = True

    def idm_handle(self, *args, **options):
        with_creators = System.objects.filter(
            role_pushes__isnull=True,
            creator__isnull=False,
        )
        for system in with_creators:
            log.info('Resetting creator for system %s', system.slug)
            system.creator = None
            system.save(update_fields=['creator'])
