#  -*- coding: utf-8 -*-



from django.core.management.base import BaseCommand
from django.db import connection

from idm.core.management.base import IdmBaseCommand


class Command(IdmBaseCommand):
    help = 'Проверяет наличие изменений в регламенте подтверждения ролей и создает новые аппрувы по необходимости.'
    sql = '''
WITH actions AS (
SELECT upravlyator_action.role_id, MAX(upravlyator_action.added) AS added
    FROM upravlyator_action
    GROUP BY upravlyator_action.role_id
    ORDER BY upravlyator_action.role_id
) 
UPDATE upravlyator_role
SET updated = actions.added
FROM actions
WHERE id=actions.role_id;
'''

    def idm_handle(self, *args, **options):
        cursor = connection.cursor()
        cursor.execute(self.sql)
