import logging
import importlib

from celery.app.task import Task

from django.core.management.base import BaseCommand, CommandError


log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Запускает celery таску по имени'

    def add_arguments(self, parser):
        parser.add_argument('--task', required=True)

    def handle(self, *args, **options):
        task_name = options.get('task')

        module, task = task_name.rsplit('.', 1)
        module = importlib.import_module(module)
        task = getattr(module, task)

        if not isinstance(task, Task):
            raise CommandError('This is not a celery task.')

        task.delay()
