# -*- coding: utf-8 -*-


import logging

import waffle

from idm.core.management.base import IdmBaseCommand
from idm.core.models import UserPassportLogin

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Напоминает пользователям о необходимости дорегистрировать паспортные логины'
    intranet_only = True

    def idm_handle(self, *args, **options):
        if waffle.switch_is_active('idm.send_notications_about_not_fully_registered_logins'):
            UserPassportLogin.objects.send_reminders_about_not_fully_registered_logins()
            log.info('All reminders about not fully registered passport_logins have been sent')
