# -*- coding: utf-8 -*-


import logging

from django.conf import settings
from idm.core.management.base import IdmBaseCommand
from idm.core.models import UserPassportLogin
from idm.utils.i18n import set_translation

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Для всех passport-login неуволенных сотрудников проставляет sid=67.'
    USE_LOCK = True
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)

        parser.add_argument(
            '--force',
            dest='force',
            action='store_true',
            default=None,
            help='Подписывать логины, даже если они отмечены как подписанные',
        )

        parser.add_argument(
            '--system', action='store', dest='system', type='system', required=False
        )

        parser.add_argument(
            '--threshold',
            action='store',
            dest='threshold',
            type='int',
            required=False,
            help='Не подписывать, если логинов больше, чем threshold. По умолчанию {}'.format(
                settings.IDM_SID67_THRESHOLD
            ),
        )

    @set_translation
    def idm_handle(self, *args, **options):
        try:
            result = UserPassportLogin.objects.subscribe_logins(
                force=options['force'],
                system=options['system'],
                threshold=options['threshold'],
            )
            if result is False:
                print('Cannot subscribe logins, because limit is exceeded')
        except Exception:
            log.exception('error during command execution')
            raise
