# -*- coding: utf-8 -*-

import logging

from idm.core.management.base import IdmBaseCommand
from idm.sync import conductor

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
        Этот скрипт импортирует группы хостов из Conductor.
    """
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--force',
            action='store_true',
            dest='force',
            default=False,
        )

    def idm_handle(self, *args, **options):
        log.info('Importing groups from Conductor')
        conductor.sync_groups(force=options.get('force'))
