# -*- coding: utf-8 -*-

import logging
import socket

from idm.core.management.base import IdmBaseCommand
from idm.sync.staff import users

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
        Этот скрипт импортирует список пользоватей из LDAP.
        А потом обновляет некоторые данные из Staff API.
    """
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)

        parser.add_argument(
            '--since',
            dest='since',
            type=int,
            help='Учитывать только сотрудников, изменных за последние N минут.',
            default=None,
        )

    @property
    def command_name(self):
        return f'{super().command_name}.full'

    def idm_handle(self, *args, **options):
        socket.setdefaulttimeout(30)

        log.info('Importing users from Staff API')
        try:
            users.import_users(since=options['since'])
        finally:
            log.info('Importing users from Staff API finished')
