# -*- coding: utf-8 -*-

from idm.core.constants.action import ACTION
from idm.core.management.base import IdmBaseCommand
from idm.core.models import Action


class Command(IdmBaseCommand):
    help = """
        Эта команда исправляет последствия бага.
        https://st.yandex-team.ru/IDM-8134
    """
    intranet_only = True

    def idm_handle(self, *args, **options):
        actions = Action.objects.filter(
            action__in=(
                ACTION.GROUP_MEMBERSHIP_INCONSISTENCIES_RESOLVED,
                ACTION.GROUP_MEMBERSHIP_INCONSISTENCIES_PUSH_FAILED
            )
        ).extra(where={"data @> '[]'"})
        for action in actions:
            action.data = {'memberships': action.data}
            action.save(update_fields=['data'])
