# -*- coding: utf-8 -*-


import logging

from idm.core.models import ApproveRequest
from idm.core.management.base import IdmBaseCommand
from idm.users.sync.gaps import sync_gaps_for_all_users

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
            Синхронизирует отсутствия пользователей с gap каждые 15 минут.
            Сотрудник отсутствует если у него суммарное отсутствие в ближайшие сутки больше 10 часов
        """
    intranet_only = True

    def idm_handle(self, *args, **options):
        sync_gaps_for_all_users()
        ApproveRequest.objects.recalculate_main_priority()
