# -*- coding: utf-8 -*-


import logging
import waffle

from idm.core.models import GroupMembershipSystemRelation, System
from idm.core.management.base import IdmBaseCommand

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Синхронизирует информацию о членства про которые необходимо сообщать в системы'
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', type='system', required=False
        )

    def sync_system(self, system):
        log.info('Start groupmembership_system_relations synchronizations for %s', system.slug)
        GroupMembershipSystemRelation.objects.sync_groupmembership_system_relations(system)
        log.info('Groupmembership_system_relations for %s have been updated', system.slug)

    def idm_handle(self, *args, **options):
        system = options.get('system')
        if system:
            self.sync_system(system)
        else:
            log.info('Start groupmembership_system_relations synchronizations')
            systems = System.objects.get_systems_with_group_sync_policy()
            for system in systems:
                self.sync_system(system)
            log.info('All groupmembership_system_relations have been updated')
