import logging

from idm.core.management.base import IdmBaseCommand
from idm.users.tasks import SyncGroups


log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Данная manage.py команда синхронизирует группы IDM с группами Стаффа'
    intranet_only = True

    USE_LOCK = False

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--block',
            action='store_true',
            dest='block',
            default=False,
        )

    def idm_handle(self, *args, **options):
        block = options.get('block')
        task = SyncGroups if block else SyncGroups.delay
        task(block=block)
