# -*- coding: utf-8 -*-

import logging

from idm.core.management.base import IdmBaseCommand
from idm.sync import racktables

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """
        Этот скрипт импортирует сетевые макросы из Racktables.
    """
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--force',
            action='store_true',
            dest='force',
            default=False,
        )

    def idm_handle(self, *args, **options):
        log.info('Importing macros from Racktables API')
        racktables.sync_macros(force=options.get('force'))
