# coding: utf-8


import logging

from django.db import transaction

from idm.core.management.base import IdmBaseCommand
from idm.permissions.utils import sync_permissions

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """Синхронизирует пермишены внутренних ролей"""

    options = ('add_only', 'remove_only', 'global_only', 'local_only', 'root_only')

    # ToDo: возможно вернуть после https://st.yandex-team.ru/IDM-7780
    intranet_only = True

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--add-only', action='store_true', dest='add_only', default=False,
        )
        parser.add_argument(
            '--remove-only', action='store_true', dest='remove_only', default=False,
        )
        parser.add_argument(
            '--global-only', action='store_true', dest='global_only', default=False,
        )
        parser.add_argument(
            '--local-only', action='store_true', dest='local_only', default=False,
        )
        parser.add_argument(
            '--root-only', action='store_true', dest='root_only', default=False,
        )

    def idm_handle(self, *args, **options):
        with transaction.atomic():
            sync_permissions(**{
                option: options.get(option) for option in self.options
            })
