import logging

from idm.core.constants.rolefield import FIELD_STATE
from idm.core.management.base import IdmBaseCommand
from idm.core.models import SystemRoleField
from idm.core.tasks import CreateRoleFieldIndex, DropRoleFieldIndex

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = "Синхронизирует индексы для role fields по полям заданным в системе"

    def idm_handle(self, *args, **options):
        rolefields = SystemRoleField.objects.filter(
            state__in=[FIELD_STATE.CREATED, FIELD_STATE.DEPRIVING]
        ).values('id', 'state')

        state_classes = {
            FIELD_STATE.CREATED: CreateRoleFieldIndex,
            FIELD_STATE.DEPRIVING: DropRoleFieldIndex,
        }

        for rolefield in rolefields:
            task_class = state_classes.get(rolefield['state'])
            if task_class is None:
                log.warning('Not found class for state %s', rolefields['state'])
                continue

            task = task_class
            task.apply_async(kwargs={
                'field_id': rolefield['id'],
            })
