# -*- coding: utf-8 -*-


import logging

import waffle

from idm.core.management.base import IdmBaseCommand
from idm.services.sync.services import sync_services_async

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = 'Данная manage.py команда синхронизирует сервисы в IDM с сервисами ABC'

    USE_LOCK = False
    intranet_only = True

    def idm_handle(self, *args, **options):
        if waffle.switch_is_active('service_syncing'):
            sync_services_async()
