# -*- coding: utf-8 -*-


import logging

from idm.core.management.base import IdmBaseCommand
from idm.core.models import System

log = logging.getLogger(__name__)


class Command(IdmBaseCommand):
    help = """Обновляет статистику по системам, что позволяет более лучше раскидывать задачи по очередям"""

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--system', action='store', dest='system', type='system', required=False
        )

    def idm_handle(self, *args, **options):
        system = options.get('system')
        systems = System.objects.all()
        if system:
            systems = systems.filter(pk=system.pk)
        for system in systems:
            system.active_nodes_count = system.nodes.active().count()
            system.active_roles_count = system.roles.active().count()
            system.save(update_fields=('active_nodes_count', 'active_roles_count'))
