
# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2019-08-07 09:21

from django.db import migrations, models


def bulk_update(model):
    if not model.objects.exists():
        return
    MAX_ID = model.objects.latest('id').id
    ID_STEP = 1000
    for i in range(0, MAX_ID+1, ID_STEP):
        query = model.objects.filter(id__gte=i, id__lt=i + ID_STEP)
        query.update(with_inheritance=True, with_external=True, with_robots=True)


def fill_tables(apps, schema_editor):
    Role = apps.get_model('core', 'Role')
    System = apps.get_model('core', 'System')
    bulk_update(Role)
    bulk_update(System)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0008_add_fields_to_role_and_system_1'),
    ]

    operations = [
        migrations.RunPython(fill_tables),
    ]
