# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2020-01-27 12:28
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import idm.framework.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0030_remove_recordcounter_and_rolelock'),
    ]

    operations = [
        migrations.CreateModel(
            name='SystemRoleField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(default='', max_length=255, unique=True)),
                ('name', models.CharField(blank=True, db_index=True, default='', max_length=255, verbose_name='Название')),
                ('name_en', models.CharField(blank=True, db_index=True, default='', max_length=255, verbose_name='Название (англ.)')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Дата создания')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Дата обновления')),
                ('type', models.CharField(choices=[('charfield', 'Текстовое поле'), ('passportlogin', 'Паспортный логин'), ('undo', 'Отменить вышестоящее поле'), ('integerfield', 'Целое поле'), ('booleanfield', 'Булево поле. По умолчанию - checkbox'), ('choicefield', 'Выбор одного варианта из нескольких. По умолчанию – select'), ('suggestfield', 'Выбор одного из предлагаемых саджестом')], db_index=True, default='charfield', max_length=255, verbose_name='Тип поля')),
                ('options', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='Настройки поля')),
                ('state', models.CharField(choices=[('created', 'созданo'), ('active', 'активно'), ('depriving', 'отзывается'), ('deprived', 'отозвано')], db_index=True, default='created', max_length=50, verbose_name='Состояние поля')),
                ('system', idm.framework.fields.StrictForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='systemrolefields', to='core.System')),
            ],
        ),
    ]
