# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2020-02-17 17:25
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import idm.framework.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0033_sync_and_push_actions'),
    ]

    operations = [
        migrations.CreateModel(
            name='RoleNodeResponsibilityAction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(choices=[('request', 'запросил'), ('ignore', 'воздержался'), ('import', 'импортировал'), ('approve', 'подтвердил'), ('decline', 'отклонил'), ('await', 'поставил в ожидание'), ('sent', 'роль передана в систему'), ('grant', 'выдал'), ('hold', 'отложил'), ('deprive', 'отозвал'), ('redeprive', 'повторный отзыв роли'), ('fail', 'ошибка'), ('expire', 'роль просрочена'), ('rerequest', 'перезапросил'), ('ask_rerequest', 'попроcил перезапросить'), ('keep_granted', 'оставил активной'), ('remove', 'удалил'), ('remote_remove', 'удалил из системы'), ('review_rerequest', 'перезапросил в связи с пересмотром'), ('restore', 'восстановил'), ('apply_workflow', 'применил workflow'), ('rerun_workflow', 'переприменил workflow'), ('workflow_comment', 'прокомментировал'), ('start_discussion', 'начал обсуждение'), ('mass_action', 'совершил массовое действие'), ('change_workflow', 'изменил workflow'), ('resolve_inconsistency', 'разрешил расхождение'), ('started_comparison_with_system', 'запустил сравнение ролей с системой'), ('compared_with_system', 'завершил сравнение ролей с системой'), ('started_sync_with_system', 'запустил разрешение расхождений'), ('synced_with_system', 'завершил разрешение расхождений'), ('system_marked_broken', 'пометил систему сломанной'), ('system_marked_recovered', 'пометил систему починенной'), ('system_created', 'создал систему'), ('system_updated', 'обновил систему'), ('system_shutdown', 'выключил систему'), ('update_roles_tree', '[old] запустил обновление дерева ролей'), ('role_tree_started_sync', 'запустил обновление дерева ролей'), ('role_tree_synced', 'завершил обновление дерева ролей'), ('role_node_created', 'добавил узел дерева ролей'), ('role_node_changed', 'изменил узел дерева ролей'), ('role_node_moved', 'переместил узел дерева ролей'), ('role_node_deleted', 'удалил узел дерева ролей'), ('role_node_marked_depriving', 'пометил для удаления узел дерева ролей'), ('role_node_roles_deprived', 'удалил все роли для узла дерева ролей'), ('role_node_field_created', 'добавил поле к узлу дерева ролей'), ('role_node_field_removed', 'удалил поле узла дерева ролей'), ('role_node_field_changed', 'изменил поле узла дерева ролей'), ('role_node_alias_created', 'добавил синоним узла дерева ролей'), ('role_node_alias_removed', 'удалил синоним узла дерева ролей'), ('role_node_responsibility_created', 'добавил ответственного узлу дерева ролей'), ('role_node_responsibility_removed', 'удалил ответственного узла дерева ролей'), ('role_node_responsibility_changed', 'изменил ответственного узла дерева ролей'), ('group_created', 'добавил группу пользователей'), ('group_moved', 'переместил группу пользователей'), ('group_deleted', 'удалил группу пользователей'), ('group_changed', 'изменил группу пользователей'), ('service_created', 'добавил сервис'), ('service_moved', 'переместил сервис'), ('service_changed', 'изменил сервис'), ('service_removed', 'удалил сервис'), ('service_restored', 'восстановил сервис'), ('user_ad_unknown', 'выполнил действие с AD'), ('user_ad_disable', 'деактивировал аккаунт в AD'), ('user_ad_enable', 'активировал аккаунт в AD'), ('user_ad_move_to_old', 'перенёс в Old Users'), ('user_ad_move_back', 'восстановил из Old Users'), ('user_ad_add_to_group', 'добавил в AD-группу'), ('user_ad_remove_from_group', 'удалил из AD-группы'), ('user_ad_return_to_group', 'вернул в AD-группу'), ('user_change_department', 'сменил отдел'), ('user_joined_group', 'присоединился к группе'), ('user_quit_group', 'покинул группу'), ('group_responsible_added', 'стал ответственным группы'), ('group_responsible_removed', 'перестал быть ответственным группы'), ('robot_responsible_added', 'стал владельцем робота'), ('robot_responsible_removed', 'перестал быть владельцем робота'), ('report_requested', 'заказал отчет'), ('subscribed', 'подписал логин'), ('unsubscribed', 'снял подписку с логина'), ('sysmembership_activate', 'активация'), ('sysmembership_activation_failed', 'активация не удалась'), ('sysmembership_deprive', 'удаление'), ('sysmembership_deprivation_failed', 'удаление не удалось'), ('sysmembership_login_updated', 'обновил логин'), ('sysmembership_login_update_failed', 'обновление логина не удалось'), ('group_membership_inconsistencies_resolved', 'разрешил расхождения в составе групп'), ('group_membership_inconsistency_push_failed', 'разрешение расхождений в составе групп не удалось'), ('transfer_accepted', 'признал существенным'), ('transfer_rejected', 'признал несущественным'), ('transfer_expired', 'перемещение устарело'), ('transfers_started_decision', 'запустил разрешение перемещений'), ('transfers_decided', 'завершил разрешение перемещений'), ('gap_synchronization_started', 'синхронизация с Гэпом началась'), ('gap_synchronization_completed', 'синхронизация с Гэпом завершилась'), ('organization_created', 'создал организацию'), ('organization_removed', 'удалил организацию'), ('user_joined_organization', 'присоединился к организации'), ('user_quit_organization', 'покинул организацию'), ('started_memberships_sync_with_system', 'запустил синхронизацию членств'), ('finished_memberships_sync_with_system', 'завершил синхронизацию членств'), ('started_memberships_push_to_system', 'запустил отправку членств в систему'), ('finished_memberships_push_to_system', 'завершил отправку членств в систему')], db_index=True, max_length=50, null=True, verbose_name='Действие')),
                ('added', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='дата')),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('node_responsibility', idm.framework.fields.StrictForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='actions', to='core.NodeResponsibility', verbose_name='Ответственный узла дерева ролей')),
            ],
            options={
                'verbose_name': 'Действие с ответственностью за узел',
                'verbose_name_plural': 'Действия с ответственностью за узел',
            },
        ),
        migrations.AlterField(
            model_name='action',
            name='node_responsibility',
            field=idm.framework.fields.StrictForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='old_actions', to='core.NodeResponsibility', verbose_name='Ответственный узла дерева ролей'),
        ),
        migrations.AddField(
            model_name='rolenoderesponsibilityaction',
            name='parent',
            field=idm.framework.fields.StrictForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rolenoderesponsibilitychildren', to='core.Action', verbose_name='Родитель'),
        ),
        migrations.AddField(
            model_name='rolenoderesponsibilityaction',
            name='requester',
            field=idm.framework.fields.StrictForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='requestedrolenoderesponsibilityactions', to=settings.AUTH_USER_MODEL, verbose_name='От имени'),
        ),
        migrations.AddField(
            model_name='rolenoderesponsibilityaction',
            name='role_node',
            field=idm.framework.fields.StrictForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='rolenoderesponsibilityactions', to='core.RoleNode', verbose_name='Узел дерева ролей'),
        ),
        migrations.AddField(
            model_name='rolenoderesponsibilityaction',
            name='system',
            field=idm.framework.fields.StrictForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rolenoderesponsibilityactions', to='core.System', verbose_name='Система'),
        ),
    ]
