# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2020-02-28 09:31
from __future__ import unicode_literals

from django.db import migrations


def nullable_max(a, b):
    if b is None:
        return a
    elif a is None:
        return b
    else:
        return a if a >= b else b



def forward(apps, schema_editor):
    System = apps.get_model('core', 'System')
    SystemMetainfo = apps.get_model('core', 'SystemMetainfo')
    for system in System.objects.all():
        if system.metainfo is None:
            system.metainfo = SystemMetainfo.objects.create()
            system.save(update_fields=['metainfo'])
        system.metainfo.last_check_inconsistencies_start = nullable_max(system.last_check_at, system.metainfo.last_check_inconsistencies_start)
        system.metainfo.last_check_inconsistencies_finish = nullable_max(system.last_check_at, system.metainfo.last_check_inconsistencies_finish)
        system.metainfo.last_sync_nodes_start = nullable_max(system.last_sync_start_at, system.metainfo.last_sync_nodes_start)
        system.metainfo.last_sync_nodes_finish = nullable_max(system.last_sync_at, system.metainfo.last_sync_nodes_finish)
        system.metainfo.save(update_fields=[
            'last_check_inconsistencies_start',
            'last_check_inconsistencies_finish',
            'last_sync_nodes_start',
            'last_sync_nodes_finish',
        ])



def backward(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0036_systemmetainfo_model'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
        migrations.RemoveField(
            model_name='system',
            name='last_check_at',
        ),
        migrations.RemoveField(
            model_name='system',
            name='last_sync_at',
        ),
        migrations.RemoveField(
            model_name='system',
            name='last_sync_start_at',
        ),
    ]
