from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.core.constants.action import ACTION
from idm.framework.fields import NullJSONField as JSONField
from idm.core.models.baseaction import BaseAction
from idm.core.querysets.action import ActionManager
from idm.framework.fields import StrictForeignKey, JSONFieldDjangoEncoder


class Action(BaseAction):
    role = StrictForeignKey(
        'core.Role',
        verbose_name=_('Роль'),
        related_name='actions',
        null=True, blank=True, default=None,
        on_delete=models.CASCADE,
    )
    user = StrictForeignKey(
        'users.User',
        verbose_name=_('Сотрудник'),
        related_name='actions',
        null=True,
        on_delete=models.CASCADE,
    )
    system = StrictForeignKey(
        'core.System',
        verbose_name=_('Система'),
        null=True,
        blank=True,
        related_name='actions',
        on_delete=models.CASCADE,
    )
    inconsistency = StrictForeignKey(
        'core.Inconsistency',
        null=True,
        blank=True,
        verbose_name=_('Расхождение'),
        related_name='actions',
        on_delete=models.SET_NULL,
    )
    group = StrictForeignKey(
        'users.Group',
        null=True,
        blank=True,
        related_name='actions',
        verbose_name=_('Группа'),
        on_delete=models.CASCADE,
    )
    service = StrictForeignKey(
        'services.Service',
        null=True,
        blank=True,
        related_name='actions',
        verbose_name=_('Сервис'),
        on_delete=models.CASCADE,
    )
    rolerequest = StrictForeignKey(
        'core.RoleRequest',
        null=True, blank=True, default=None,
        verbose_name=_('Запрос роли'),
        related_name='actions',
        on_delete=models.CASCADE,
    )
    approverequest = StrictForeignKey(
        'core.ApproveRequest',
        null=True, blank=True, default=None,
        verbose_name=_('Запрос подтверждения'),
        related_name='actions',
        on_delete=models.CASCADE,
    )
    role_node = StrictForeignKey(
        'core.RoleNode',
        null=True, blank=True, default=None,
        verbose_name=_('Узел дерева ролей'),
        related_name='actions',
        on_delete=models.SET_NULL,
    )
    role_field = StrictForeignKey(
        'core.RoleField',
        null=True, blank=True, default=None,
        verbose_name=_('Поле узла дерева ролей'),
        related_name='actions',
        on_delete=models.SET_NULL,
    )
    role_alias = StrictForeignKey(
        'core.RoleAlias',
        null=True, blank=True, default=None,
        verbose_name=_('Синоним узла дерева ролей'),
        related_name='actions',
        on_delete=models.SET_NULL,
    )
    node_responsibility = StrictForeignKey(
        'core.NodeResponsibility',
        null=True, blank=True, default=None,
        verbose_name=_('Ответственный узла дерева ролей'),
        related_name='old_actions',
        on_delete=models.SET_NULL,
    )
    requester = StrictForeignKey(
        'users.User',
        verbose_name=_('От имени'),
        related_name='requested',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    impersonator = StrictForeignKey(
        'users.User',
        verbose_name=_('Запросивший'),
        related_name='impersonated',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    robot = StrictForeignKey(
        'users.User',
        verbose_name=_('Робот'),
        related_name='owns',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    membership = StrictForeignKey(
        'users.GroupMembership',
        verbose_name=_('Участие'),
        related_name='actions',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    sysmembership = StrictForeignKey(
        'core.GroupMembershipSystemRelation',
        verbose_name=_('Посистемное участие'),
        related_name='actions',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    workflow = StrictForeignKey(
        'core.Workflow',
        verbose_name=_('Workflow'),
        related_name='actions',
        null=True, default=None,
        on_delete=models.SET_NULL,
    )
    responsibility = StrictForeignKey(
        'users.GroupResponsibility',
        verbose_name=_('Ответственность'),
        related_name='actions',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    passport_login = StrictForeignKey(
        'core.UserPassportLogin',
        verbose_name=_('Паспортный логин'),
        related_name='actions',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    transfer = StrictForeignKey(
        'core.Transfer',
        verbose_name=_('Перемещение'),
        related_name='actions',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    organization = StrictForeignKey(
        'users.Organization',
        verbose_name=_('Организация'),
        related_name='actions',
        null=True,
        on_delete=models.CASCADE,
    )
    organization_membership = StrictForeignKey(
        'users.OrganizationMembership',
        verbose_name=_('Членство в организации'),
        related_name='actions',
        null=True,
        on_delete=models.CASCADE,
    )
    action = models.CharField(
        verbose_name=_('Действие'),
        choices=[(key, triple[0]) for key, triple in ACTION.ACTIONS.items()],
        max_length=50,
        db_index=True,
        null=True,
    )
    added = models.DateTimeField(
        verbose_name=_('дата'),
        auto_now_add=True,
        db_index=True,
    )
    data = JSONFieldDjangoEncoder(blank=True, null=True)
    error = models.TextField(default='')
    parent = StrictForeignKey(
        'self',
        null=True, blank=True, default=None,
        verbose_name=_('Родитель'),
        related_name='children',
        on_delete=models.CASCADE,
    )

    objects = ActionManager()

    class Meta:
        ordering = ('-added', '-id')
        index_together = [('system', 'added'), ('user', 'added'), ('role', 'added'), ('action', 'added'),
                          ('system', 'action', 'added')]
        verbose_name = _('Действие')
        verbose_name_plural = _('Действия')
        db_table = 'upravlyator_action'
