from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.core.constants.action_tiny import ACTION_TINY, STATUS
from idm.framework.fields import StrictForeignKey


class ActionTiny(models.Model):
    system = StrictForeignKey(
        'core.System',
        verbose_name=_('Система'),
        null=True,
        blank=True,
        related_name='actions_tiny',
        on_delete=models.CASCADE,
    )
    start = models.DateTimeField(
        verbose_name=_('время начала'),
        db_index=True,
    )
    finish = models.DateTimeField(
        verbose_name=_('время конца'),
        db_index=True,
        null=True,
    )
    action = models.CharField(
        verbose_name=_('Действие'),
        choices=ACTION_TINY.ACTIONS,
        max_length=50,
        db_index=True,
        null=True,
    )
    status = models.CharField(
        verbose_name=_('Статус'),
        choices=STATUS.STATUSES,
        max_length=10,
        db_index=True,
        null=True,
    )
    traceback = models.TextField(default='')

    class Meta:
        verbose_name = _('Просто действие ')
        verbose_name_plural = _('Простые действия')

    def __str__(self):
        result = ['action=%s' % self.action, 'start=%s' % self.start, 'finish=%s' % self.finish]
        if self.system:
            result.append('system=%s' % self.system.slug)
        return ' '.join(result)
