import uuid

from django.db import models
from django.contrib.postgres.fields import JSONField

from idm.core.constants.batchrequest import BATCH_REQUEST_TYPE


class BatchRequest(models.Model):

    id = models.UUIDField(primary_key=True, null=False, default=uuid.uuid4)
    type = models.CharField(
        max_length=16,
        choices=BATCH_REQUEST_TYPE.CHOICES,
        default=BATCH_REQUEST_TYPE.GRANT,
        null=True,
    )
    created_at = models.DateTimeField(auto_now_add=True, editable=False)
    requester = JSONField()

    class Meta:
        # TODO: переименовать
        db_table = 'core_batchrolerequest'


class DelayedRoleRequest(models.Model):
    batch_request = models.ForeignKey(
        to=BatchRequest,
        related_name='requests',
        on_delete=models.PROTECT,
    )
    label = models.CharField(max_length=64, null=True, blank=True)
    role = models.ForeignKey(
        to='core.Role',
        related_name='+',
        null=True,
        blank=True,
        on_delete=models.PROTECT,
    )
    data = JSONField(blank=True, null=True, db_column='role_data')
    error = models.CharField(max_length=255, null=True, blank=True)
    is_done = models.BooleanField(default=False)
    is_send = models.BooleanField(default=False)

    class Meta:
        unique_together = [('batch_request', 'label')]
