from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.core.querysets.conductorgroup import ConductorGroupManager


class ConductorGroup(models.Model):
    external_id = models.IntegerField(unique=True)
    name = models.CharField(max_length=255, db_index=True)
    is_active = models.BooleanField(db_index=True, verbose_name=_('Активен'), default=True)
    created_at = models.DateTimeField(_('Дата добавления'), auto_now_add=True, editable=False)
    updated_at = models.DateTimeField(_('Дата обновления'), auto_now=True, editable=False)

    objects = ConductorGroupManager()

    def __repr__(self):
        return '<ConductorGroup: {} ({})>'.format(self.external_id, self.name)
