from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.framework.fields import StrictForeignKey


class FavoriteSystem(models.Model):
    added = models.DateTimeField(auto_now_add=True, verbose_name='Дата добавления')
    user = StrictForeignKey('users.User', related_name='favorite_systems', null=False, on_delete=models.CASCADE)
    system = StrictForeignKey('core.System', related_name='in_favorites', null=False, on_delete=models.CASCADE)

    def __str__(self):
        return '%s - %s' % (self.user.username, self.system.slug)

    class Meta:
        ordering = ('system__name',)
        unique_together = (('user', 'system'),)
        verbose_name = _('Избранная система')
        verbose_name_plural = _('Избранные системы')
        db_table = 'upravlyator_favoritesystem'
