from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.core.constants.groupmembership_system_relation import MEMBERSHIP_SYSTEM_RELATION_STATE
from idm.core.querysets.groupmembershipsystemrelation import GroupMembershipSystemRelationManager
from idm.framework.fields import StrictForeignKey


class GroupMembershipSystemRelation(models.Model):
    # TODO: Пока тут создаются записи только о непосредственных членствах, будет работать корректно после отказа от EveryMembership
    state = models.TextField(choices=MEMBERSHIP_SYSTEM_RELATION_STATE.NAMES, verbose_name=_('Статус'))
    membership = StrictForeignKey(
        'users.GroupMembership',
        verbose_name=_('Членство в группе'),
        related_name='sysmemberships',
        on_delete=models.CASCADE,
    )
    system = StrictForeignKey(
        'core.System',
        verbose_name=_('Система'),
        related_name='sysmemberships',
        on_delete=models.CASCADE,
    )
    created_at = models.DateTimeField(auto_now_add=True, verbose_name=_('Дата создания'))
    updated_at = models.DateTimeField(auto_now_add=True, verbose_name=_('Дата изменения'))
    passport_login = StrictForeignKey(
        'core.UserPassportLogin',
        verbose_name=_('Паспортный логин'),
        related_name='sysmemberships',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    need_update = models.BooleanField(default=False)

    objects = GroupMembershipSystemRelationManager()

    class Meta:
        unique_together = [('system', 'membership')]
        verbose_name = _('Посистемное членство')
        verbose_name_plural = _('Посистемные членства')

    def __repr__(self):
        return '<GroumMembershipSystemRelation: id=%s, system=%s, user=%s, group=%s, state=%s>' % (
            self.pk, self.system.slug, self.membership.user.username, self.membership.group.slug, self.state
        )
