from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _
from guardian.models import UserObjectPermissionBase, GroupObjectPermissionBase

from idm.core.querysets.internalrole import InternalRoleManager
from idm.core.querysets.iop import InternalUserObjectPermissionManager
from idm.framework.fields import StrictForeignKey


class InternalRole(models.Model):
    role = models.CharField(max_length=255, db_index=True, null=True)
    node = StrictForeignKey(
        'core.RoleNode',
        null=True,
        verbose_name=_('Узел дерева ролей'),
        related_name='internal_roles',
        on_delete=models.CASCADE,
    )

    objects = InternalRoleManager()

    class Meta:
        verbose_name = _('Internal roles')
        verbose_name_plural = _('Internal role')
        unique_together = [('role', 'node')]
        permissions = settings.IDM_PERMISSIONS
        db_table = 'upravlyator_internalrole'


class InternalRoleUserObjectPermission(UserObjectPermissionBase):
    content_object = StrictForeignKey(InternalRole, related_name='user_object_permissions', on_delete=models.CASCADE)
    objects = InternalUserObjectPermissionManager()

    class Meta(UserObjectPermissionBase.Meta):
        db_table = 'upravlyator_internalroleuserobjectpermission'
        index_together = (
            ('user', 'permission'),
        )


class InternalRoleGroupObjectPermission(GroupObjectPermissionBase):
    content_object = StrictForeignKey(
        'core.InternalRole', related_name='group_object_permissions', on_delete=models.CASCADE
    )

    class Meta:
        db_table = 'upravlyator_internalrolegroupobjectpermission'
