from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.core.querysets.networkmacro import NetworkMacroManager


class NetworkMacro(models.Model):
    slug = models.CharField(max_length=255, unique=True)
    is_active = models.BooleanField(db_index=True, verbose_name=_('Активен'), default=True)
    created_at = models.DateTimeField(_('Дата добавления'), auto_now_add=True, editable=False)
    updated_at = models.DateTimeField(_('Дата обновления'), auto_now=True, editable=False)

    objects = NetworkMacroManager()

    def __repr__(self):
        return '<NetworkMacro: {}>'.format(self.slug)
